-- Hedgewars Campaign #02
-- Scripting Example

--missed
--illgetyou
--sndRegret     youllregretthat

--perfection

loadfile(GetDataPath() .. "Scripts/Locale.lua")()

---------------------------------------------------------------

local TurnStarted = false

local player = nil -- pointer for player gear
local enemy = nil	-- pointer for enemy gear

local returnControl = false -- give back control to player if he screws up

local GameOver = false
local mWon = false

local oCirc = nil -- objective circle

local stage = 0 -- keeps track of mission/cinematic progress
local aTimer = 0 -- as above, but on a per mil second basis

local vGearTimer = 0
local vTarget = nil

function TeleportGearXY(gear, destX, destY)

	AddVisualGear(GetX(gear)-5, GetY(gear)-5, vgtSmoke, 0, false)
	AddVisualGear(GetX(gear)+5, GetY(gear)+5, vgtSmoke, 0, false)
	AddVisualGear(GetX(gear)-5, GetY(gear)+5, vgtSmoke, 0, false)
	AddVisualGear(GetX(gear)+5, GetY(gear)-5, vgtSmoke, 0, false)
	SetGearPosition(gear, destX, destY)
	AddVisualGear(GetX(gear), GetY(gear), vgtBigExplosion, 0, false)

end

---------------------------------------------------
-- functions to allow you to follow virtual gears
---------------------------------------------------

function HandleFollowVGear()

	vGearTimer = vGearTimer + 1
	if vGearTimer == 2000 then
		vGearTimer = 0
		DeleteGear(vTarget)
		vTarget = nil
	end

end

function FollowVGear(gear)

	gX,gY,g4,g5,g6,g7,g8,g9,g10,g11 =  GetVisualGearValues(gear)
	vTarget = AddGear(gX, gY, gtTarget, 0, 0, 0, 0)
	SetTag(vTarget, 4)
	FollowGear(vTarget)

end

-------------------------------
-- normal game event handlers
-------------------------------

function onGameInit()

	-- Things we don't modify here will use their default values.
	Seed = 0 -- The base number for the random number generator
	GameFlags = gfInfAttack +gfSolidLand +gfDisableWind --+ gfResetWeps -- Game settings and rules
	TurnTime = 90000 -- The time the player has to move each round (in ms)
	CaseFreq = 0 -- The frequency of crate drops
	MinesNum = 0 -- The number of mines being placed
	MinesTime  = 1000
	Explosives = 0 -- The number of explosives being placed
	Delay = 10 -- The delay between each round
	Map = "Prison2" -- The map to be played
	Theme = "Snow" -- The theme to be used

	AddTeam(loc("Cybernetic Empire"), 1175851, "Simple", "Island", "Robot","cm_binary")
	enemy = AddHog(loc("Unit 113"), 0, 100, "cyborg")

	AddTeam(loc("Pathetic Captives"), 14483456, "Simple", "Island", "Default", "Hedgewars")
	player = AddHog(loc("Prisoner 3207"), 0, 1, "NoHat") --NoHat

	SetGearPosition(player, 1665, 1759)
	SetGearPosition(enemy, 1519, 1418)

end


function onGameStart()

	-- crates crates and more crates

	gir1 = SpawnUtilityCrate(1560,1755,amGirder)
	gir12 = SpawnUtilityCrate(1560,1755,amGirder)
	gir2 = SpawnUtilityCrate(1791,1471,amGirder)
	par1 = SpawnUtilityCrate(2252,1471,amParachute)
	rop1 = SpawnUtilityCrate(2496,1755,amRope)
	blowT1 = SpawnAmmoCrate(2667,1628,amBlowTorch)
	rop2 = SpawnUtilityCrate(2673,1990,amRope)
	blowT2 = SpawnAmmoCrate(2099,1967,amBlowTorch)
	grav1 = SpawnUtilityCrate(1889,1967,amLowGravity)
	pHammer1 = SpawnAmmoCrate(1105,1801,amPickHammer)

	-- Add Mines
	AddGear(1900, 1652, gtMine, 0, 0, 0, 0)
	AddGear(1925, 1652, gtMine, 0, 0, 0, 0)
	AddGear(1950, 1652, gtMine, 0, 0, 0, 0)
	AddGear(1975, 1652, gtMine, 0, 0, 0, 0)
	AddGear(2000, 1652, gtMine, 0, 0, 0, 0)
	AddGear(2025, 1652, gtMine, 0, 0, 0, 0)
	AddGear(2050, 1652, gtMine, 0, 0, 0, 0)
	AddGear(2075, 1652, gtMine, 0, 0, 0, 0)
	AddGear(2100, 1652, gtMine, 0, 0, 0, 0)
	AddGear(2130, 1652, gtMine, 0, 0, 0, 0)

	TurnTimeLeft = 0

	FollowGear(enemy)

	SetWind(0)
	ShowMission(loc("THE DARK TIDE"), loc("Chapter II"), "", -amSkip, 0)

end



function onNewTurn()

	TurnStarted = false

	if CurrentHedgehog == player then
		SetInputMask(0xFFFFFFFF)
	elseif CurrentHedgehog == enemy then
		SetInputMask(band(0xFFFFFFFF, bnot(gmAnimate+gmAttack+gmDown+gmHJump+gmLeft+gmLJump+gmPrecise+gmRight+gmSlot+gmSwitch+gmTimer+gmUp+gmWeapon)))
		AddAmmo(enemy, amBazooka)
	end

end


function onGameTick()
					-- 2
	if (TurnTimeLeft > 0) and (TurnStarted == false) then
		TurnTimeLeft = -1
		TurnStarted = true
	end

	if vTarget ~= nil then
		HandleFollowVGear()
	end

	if CurrentHedgehog ~= nil then
		--AddCaption(ScriptGetInteger('Ready'))
		--AddCaption(stage .. ": " .. GetX(CurrentHedgehog) .. ";" .. GetY(CurrentHedgehog))
	end


	if (CurrentHedgehog == enemy) and (TurnStarted == true) then

		--if the player hurts himself accidentally and loses his turn
		--return control to the player
		--[[if returnControl == true then
			SetGearMessage(enemy, 0)
			aTimer = aTimer + 1
			if (aTimer == 2000) then
				HogSay(enemy, loc("{Sigh}"), SAY_THINK,2)
				--PlaySound(sndMissed, enemy) -- "Pathetic meatbag"
			elseif aTimer == 6000 then
				returnControl = false
				TurnTimeLeft = 1
				aTimer = 0
			end
		end]]

		if stage == 0 then

			--stage = 1 -- remove
			SetGearMessage(enemy, 0)
			aTimer = aTimer + 1

			if aTimer == 2000 then
				FollowGear(enemy)
				HogSay(enemy, loc("Hello again, 3207."), SAY_SAY,2)
			elseif aTimer == 6000 then
				HogSay(enemy, loc("It's time for more TESTS."), SAY_SAY,2)
			elseif aTimer == 10000 then
				HogSay(enemy, loc(":D"), SAY_THINK,2)
			elseif aTimer == 12000 then
				HogSay(enemy, loc("Scattered around this maze are a variety of utilities."), SAY_SAY,2)
			elseif aTimer == 18000 then
				HogSay(enemy, loc("Use them carefully, and make your way to the exit teleporter."), SAY_SAY,2)
			elseif aTimer == 22000 then
				HogSay(enemy, loc("As ever, I will be watching..."), SAY_SAY,2)
			elseif aTimer == 26000 then
				stage = 1
				aTimer = 0
			end

		elseif stage == 1 then

			TeleportGearXY(enemy,1485,1229)
			PlaySound(sndExplosion)
			stage = 2
			aTimer = 0
			TurnTimeLeft = 1

		end

	end

-------------------------------
-------------------------------
-------------------------------
-------------------------------


	if (CurrentHedgehog == player) and (TurnStarted == true) then

		if mWon == false then
			TurnTimeLeft = -1 -- lol, remove later
		end

		aTimer = aTimer + 1

		if stage == 2 then


			oCirc = AddVisualGear(473,923,vgtCircle,0,true)
			SetVisualGearValues(oCirc, 1105,1965, 10, 200, 1, 10, 0, 200, 5, GetClanColor(1))
			FollowVGear(oCirc)
			aTimer = 0
			stage = 3
			ShowMission(loc("MISSION OBJECTIVE:"), loc("Find your way to the marked teleporter."), "", 2, 0)

		elseif stage == 3 then

			if (GetX(CurrentHedgehog) > 1094) and (GetX(CurrentHedgehog) < 1119) and (GetY(CurrentHedgehog) == 1965)then
				aTimer = 0
				mWon = true
				stage = 4
				TurnTimeLeft = 1
				ParseCommand("teamgone Cybernetic Empire")
				ShowMission(loc("MISSION COMPLETE"), loc("Congratulations!"), "", 0, 0)
			end

		end

	end


end


function onAmmoStoreInit()
	SetAmmo(amGirder, 0, 0, 0, 1)
	SetAmmo(amParachute, 0, 0, 0, 1)
	SetAmmo(amRope, 0, 0, 0, 1)
	SetAmmo(amBlowTorch, 0, 0, 0, 1)
	SetAmmo(amLowGravity, 0, 0, 0, 1)
	SetAmmo(amPickHammer, 0, 0, 0, 1)
	--SetAmmo(amTeleport, 9, 0, 0, 0)
	--SetAmmo(amSkip, 0, 0, 0, 0)
end


function onSetWeapon()
	--
end

function onGearAdd(gear)
-- not needed today
end

function onGearDamage(gear, damage)

	-- return control to player if he accidentally hurts himself
	-- see onGameTick()
	--if (gear == player) and (stage ~= 23) then
	--	returnControl = true
	--	aTimer = 0
	--end

end

function onGearDelete(gear)

	--if gear == bazCrate then
	--	ShowMission(loc("OBJECTIVE COMPLETE"), loc("You've found a bazooka!"), loc("Use [right click] to open the weapons menu"), -amBazooka, 0)
	--end


	if (gear == enemy) and (GameOver == false) then
		ShowMission(loc("SAY WHAT"), loc("HOW DID YOU DO THAT?"), loc("YOU CRAZY FOOL."), 0, 0);
	elseif (gear == player) and (mWon == false) then
		FollowGear(enemy)
		HogSay(enemy, loc("Pathetic!"), SAY_SAY,2)
		ShowMission(loc("MISSION FAILED"), loc("Prisoner 3207 must survive."), "", -amSkip, 0)
		GameOver = true
		PlaySound(sndMissed, enemy) -- "Pathetic meatbag"
	end

end
